<?php

namespace App\Enums;

enum CurrencyEnum
{
    const USD = ['en' => 'USD', 'tr' => 'USD', 'ar' => 'دولار أمريكي'];
    const SYP = ['en' => 'SYP', 'tr' => 'SYP', 'ar' => 'ليرة  سورية'];
    const TRY = ['en' => 'TRY', 'tr' => 'TRY', 'ar' => 'ليرة تركية'];
    const EUR = ['en' => 'EUR', 'tr' => 'EUR', 'ar' => 'يورو'];
    const GOLD = ['en' => 'GOLD', 'tr' => 'Altın', 'ar' => 'ذهب'];
    const SAR = ['en' => 'SAR', 'tr' => 'SAR', 'ar' => 'ريال سعودي'];
    const RUB = ['en' => 'RUB', 'tr' => 'RUB', 'ar' => 'روبل روسي'];
    const KWD = ['en' => 'KWD', 'tr' => 'KWD', 'ar' => 'دينار كويتي'];
    const EGP = ['en' => 'EGP', 'tr' => 'EGP', 'ar' => 'جنيه مصري'];
    const QAR = ['en' => 'QAR', 'tr' => 'QAR', 'ar' => 'ريال قطري'];
    const OMR = ['en' => 'OMR', 'tr' => 'OMR', 'ar' => 'ريال عماني'];
    const BHD = ['en' => 'BHD', 'tr' => 'BHD', 'ar' => 'دينار بحريني'];
    const AED = ['en' => 'AED', 'tr' => 'AED', 'ar' => 'درهم اماراتي'];
    public function getName(string $lang = 'en'): string
    {
        return match ($this) {
            self::USD => ['en' => 'USD', 'tr' => 'USD', 'ar' => 'دولار أمريكي'][$lang] ?? 'USD',
            self::SYP => ['en' => 'SYP', 'tr' => 'SYP', 'ar' => 'ليرة سورية'][$lang] ?? 'SYP',
            self::TRY => ['en' => 'TRY', 'tr' => 'TRY', 'ar' => 'ليرة تركية'][$lang] ?? 'TRY',
            self::EUR => ['en' => 'EUR', 'tr' => 'EUR', 'ar' => 'يورو'][$lang] ?? 'EUR',
            self::GOLD => ['en' => 'GOLD', 'tr' => 'Altın', 'ar' => 'ذهب'][$lang] ?? 'GOLD',
            self::SAR => ['en' => 'SAR', 'tr' => 'SAR', 'ar' => 'ريال سعودي'][$lang] ?? 'SAR',
            self::RUB => ['en' => 'RUB', 'tr' => 'RUB', 'ar' => 'روبل روسي'][$lang] ?? 'RUB',
            self::KWD => ['en' => 'KWD', 'tr' => 'KWD', 'ar' => 'دينار كويتي'][$lang] ?? 'KWD',
            self::EGP => ['en' => 'EGP', 'tr' => 'EGP', 'ar' => 'جنيه مصري'][$lang] ?? 'EGP',
            self::QAR => ['en' => 'QAR', 'tr' => 'QAR', 'ar' => 'ريال قطري'][$lang] ?? 'QAR',
            self::OMR => ['en' => 'OMR', 'tr' => 'OMR', 'ar' => 'ريال عماني'][$lang] ?? 'OMR',
            self::BHD => ['en' => 'BHD', 'tr' => 'BHD', 'ar' => 'دينار بحريني'][$lang] ?? 'BHD',
            self::AED => ['en' => 'AED', 'tr' => 'AED', 'ar' => 'درهم اماراتي'][$lang] ?? 'AED',
        };
    }
}
