<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;

class AgentForceLogout implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets;

    public $agentId;

    public function __construct($agentId)
    {
        $this->agentId = $agentId;
    }

    public function broadcastOn()
    {
        return new Channel('agent-logout.' . $this->agentId);
    }
}
