<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Support\Facades\Log;

class RefreshDataTable implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    protected $table;
    public function __construct($table)
    {
        $this->table = $table;
        Log::info("RefreshDataTable");
    }

    public  function broadcastWith()
    {
        return [
            'table' => $this->table,
        ];
    }
    public function broadcastAs()
    {
        return 'RefreshDataTable'; // this is the name you'll listen for in JS
    }

    public function broadcastOn(): array
    {
        return [
            new Channel('RefreshDataTable'),
        ];
    }
}
