<?php

namespace App\Http\Controllers;

use App\Models\Property;
use Barryvdh\Elfinder\Connector;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class FileController extends Controller
{
    public function showConnector(Request $request)
    {
        $modelname = $request->modelname;
        $id = $request->modelid;
        if ($modelname == "Property" && isset($id)) {
            $property = Property::find($id);
            $portfolio_id = $property->portfolio_id;
            $name = $property->name;
            $path = storage_path('app/public/Documents/Portfolio/' . $portfolio_id . '/' . $name . "_" . $id);
            $url = url('storage/Documents/Portfolio/' . $portfolio_id . '/' . $name . "_" . $id);
        } else {
            $path = storage_path('app/public/Documents/' . $modelname . '/' . $id);
            $url = url('storage/Documents/' . $modelname . '/' . $id);
        }

        //$path = storage_path('app/public/Documents/' . $modelname . '/' . $id);
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $roots = [
            [
                'driver'        => 'LocalFileSystem',
                'path'          => $path,
                'URL'           => url($url),
                'uploadAllow'   => ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'application/pdf'],
                'uploadDeny'    => ['all'], // Deny all other types
                'uploadOrder'   => ['deny', 'allow'], // Process deny rules first
                'accessControl' => 'access',
                'acceptedName'  => '/^[^\.].*$/' // Don't allow files starting with dot
            ]
        ];

        $opts = ['roots' => $roots];

        $connector = new Connector(new \elFinder($opts));
        $connector->run();
        return $connector->getResponse();
    }
}
