<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureTwoFactorSetup
{
    /**
     * Routes to exclude from 2FA enforcement.
     */
    protected $except = [
        'two-factor.setup',   // setup page
        'two-factor.login',   // challenge page,
        'two-factor.confirm', // confirmation page
        'two-factor.challenge', // disable page
        'logout',             // logout
    ];

    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();
        if ($request->route() && in_array($request->route()->getName(), $this->except) && $request->route() == "two-factor-challenge") {
            return $next($request);
        }

        // Skip if user is not authenticated
        if (!$user) {
            return $next($request);
        }

        // Skip excepted routes
        if ($request->route() && in_array($request->route()->getName(), $this->except)) {
            return $next($request);
        }

        // Force 2FA setup if not confirmed
        //   if (!$user->two_factor_confirmed_at) {
        //      return redirect()->route('two-factor.setup');
        // }

        // Force 2FA challenge if setup done but not passed in this session
        // if ($user->two_factor_secret && !$request->session()->get('two_factor_passed')) {
        //     return redirect()->route('two-factor.login');
        // }

        return $next($request);
    }
}
