<?php

namespace App\Jobs;

use App\Models\LedgerTransfer;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CreateLedgerTransfersJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected int $count;

    public function __construct(int $count = 1000)
    {
        $this->count = $count;
    }

    public function handle()
    {
        LedgerTransfer::factory()->count($this->count)->create();
    }
}
