<?php
// app/Listeners/SetTransactionCreatorListener.php
namespace App\Listeners;

use Bavix\Wallet\Internal\Events\TransactionCreatedEventInterface;
use Bavix\Wallet\Models\Transaction;
use Illuminate\Support\Facades\Auth;

class SetTransactionCreatorListener
{
    public function handle(TransactionCreatedEventInterface $event): void
    {
        $transaction = Transaction::find($event->getId());

        if ($transaction && Auth::hasUser()) {
            $transaction->created_by = Auth::id();
            $transaction->saveQuietly(); // Use saveQuietly to prevent event recursion
        }
    }
}
