<?php

namespace App\Livewire\Accounts;

use App\Models\BalanceOverwrite;
use App\Models\Currency;
use App\Models\CustomLedgerAccount;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Rawilk\Settings\Facades\Settings;

class Statistics extends Component
{
    public array $selectedCurrencies = [];
    public  $statistics = [];
    public $show_balance_details = false;
    public $accountId;
    public $html;
    protected function getListeners()
    {
        return [
            'toggleActionButtons' => 'toggleActionButtons',
            'CopyBalanceReconiliation' => 'CopyBalanceReconiliation',

        ];
    }
    public function toggleActionButtons($value, $checked)
    {
        $account = CustomLedgerAccount::where("code", $value)->first();
        if ($account) {
            $extra = $account->extra;
            $extra['show'] = $checked;
            $account->extra = $extra;
            $account->save();
        }
    }
    public function mount()
    {
        $this->show_balance_details = session('showBalancesDetails') ?? false;
        $this->statistics = $this->getBalanceStatistics();

        $this->selectedCurrencies = session('balance_selected_currencies') ?? [];

        if (empty($this->selectedCurrencies)) {
            // If no session or it's empty, select all currencies
            $this->selectedCurrencies = array_keys($this->statistics);
            session()->put('balance_selected_currencies', $this->selectedCurrencies);
        }
    }
    public function getBalanceStatistics()
    {
        // Get currencies first
        $currencies = Currency::pluck('name', 'code');

        // Single query to get sums and counts grouped by currency and sign
        $query = BalanceOverwrite::select(
            'currency',
            DB::raw('SUM(CASE WHEN balance >= 0 THEN balance ELSE 0 END) as positive_balance'),
            DB::raw('SUM(CASE WHEN balance < 0 THEN balance ELSE 0 END) as negative_balance'),
            DB::raw('COUNT(CASE WHEN balance >= 0 THEN 1 END) as positive_accounts'),
            DB::raw('COUNT(CASE WHEN balance < 0 THEN 1 END) as negative_accounts')
        );
        if (auth()->guard('agent')->check()) {
            $agent_ids = auth()->guard('agent')->user()->agent->rootAgent()->getallchildid();

            $query = $query->wherehas('account', function ($query) use ($agent_ids) {
                $query->whereIn('extra->agent_id', $agent_ids)->where("extra->type", "cashier");
            });
        }
        $results = $query->groupBy('currency')

            ->get()
            ->keyBy('currency');

        $statistics = [];

        foreach ($currencies as $code => $name) {
            $stat = $results->get($code);

            $positiveBalance = $stat->positive_balance ?? 0;
            $negativeBalance = $stat->negative_balance ?? 0;

            $statistics[$code] = [
                'currency_name' => $name,
                'positive_balance' => $positiveBalance,
                'negative_balance' => $negativeBalance,
                'positive_accounts' => $stat->positive_accounts ?? 0,
                'negative_accounts' => $stat->negative_accounts ?? 0,

                // Add badge colors depending on value (example logic)
                'positive_badge_class' => $positiveBalance > 0 ? 'bg-label-success' : 'bg-label-secondary',
                'negative_badge_class' => $negativeBalance < 0 ? 'bg-label-danger' : 'bg-label-secondary',
            ];
        }

        return $statistics;
    }
    public  function updated($key, $value)
    {

        $this->applyFilters();
    }
    public function selectAllCurrencies()
    {
        $this->selectedCurrencies = array_keys($this->statistics);
        $this->applyFilters();
    }

    public function clearAllCurrencies()
    {
        $this->selectedCurrencies = [];
        $this->applyFilters();
    }
    public  function ShowBalancesDetails()
    {

        $this->show_balance_details = !$this->show_balance_details;
        session()->put('showBalancesDetails', $this->show_balance_details);
        $this->applyFilters();
    }
    public function applyFilters()
    {
        session()->put('balance_selected_currencies', $this->selectedCurrencies);
        //  $written_balance_reconciliation_content =  $this->parseVariables(Settings::get('written_balance_reconciliation_content', ''));
        $this->dispatch('SetBalanceReconciliationAccountId', ['accountId' => $this->accountId]);
        //   $this->dispatch('filtersApplied', ["filters" => ['currencies' => $this->selectedCurrencies], "table_id" => 'balance-table', 'action' => 'reinit']);
        $this->redirect(request()->header('Referer') ?? route('balances.index'));
    }
    public  function  CopyBalanceReconiliation($code)
    {

        $account = CustomLedgerAccount::where('code', $code)->first();
        $balances = $account->getAgentBalances();
        $html =  (Settings::get('balance_reconciliation_content', ''));
        $this->html = getBalanceReconciliationhtml($html, $balances);
        $this->dispatch("CopyBalanceReconiliationEvent");
    }
    public function render()
    {
        return view('livewire.accounts.statistics');
    }
}
