<?php

namespace App\Livewire\AgentPanel\Statement;

use Abivia\Ledger\Models\JournalEntry;
use App\Models\Currency;
use Carbon\Carbon;
use Livewire\Component;

class Filter extends Component
{
  public $currencies = [];
  public $accounts = [];
  public $dateFilter = 'custom'; // القيمة الافتراضية

  public $fromDate;
  public $toDate;
  public $currency;
  public $accountId;
  public $account;
  public $showFilter = false;

  protected  function getListeners()
  {
    return [
      'toggleChangeStatementReview' => 'UpdateReview',

    ];
  }

  public function onDateFilterChange()
  {
    switch ($this->dateFilter) {
      case 'today':
        $this->fromDate = Carbon::today()->format('Y-m-d');
        $this->toDate = Carbon::today()->format('Y-m-d');
        break;

      case 'this_month':
        $this->fromDate = Carbon::now()->startOfMonth()->format('Y-m-d');
        $this->toDate = Carbon::now()->endOfMonth()->format('Y-m-d');
        break;

      case 'this_year':
        $this->fromDate = Carbon::now()->startOfYear()->format('Y-m-d');
        $this->toDate = Carbon::now()->endOfYear()->format('Y-m-d');
        break;

      case 'all':
        $this->fromDate = null;
        $this->toDate = null;
        break;

      case 'custom':
      default:
        // لا تغير التاريخ تلقائيًا، المستخدم سيختار يدويًا
        break;
    }
  }
  public  function UpdateReview($value, $checked)
  {


    $entry = JournalEntry::find($value);
    $entry->reviewed = $checked;
    $entry->save();
  }
  public function mount($account, $accounts = "agent")
  {

    $agent = auth('agent')->user()->agent->rootAgent();
    if ($accounts == "cashier") {
      $agent_childs = $agent->getallchildid();
      // Exclude the current agent ID from children
      $agent_childs = array_filter($agent_childs, function ($childId) use ($agent) {
        return $childId != $agent->id;
      });
    } else {
      $agent_childs = [$agent->id];
    }

    $this->accounts = \App\Models\LedgerAccountOverwrite::whereIn("extra->agent_id", $agent_childs)
      ->where('category', false)->where(function ($query) use ($agent) {
        // $query->where('extra->type', '=', 'cashier');
      })->get();
    $this->account = $account;
    $this->fromDate = now()->subMonth()->format('Y-m-d');
    $this->toDate = now()->format('Y-m-d');


    $this->currencies = \App\Models\Currency::all();
  }
  public  function updated()
  {
    $currency = Currency::where('code', $this->currency)->first();
    // if ($currency && $this->accountId) {
    $this->account = $this->accountId; //getAgentAccountCode($this->accountId, '11');

    // }

  }
  public function  applyFilter()
  {
    $this->dispatch('SetAgentId', ['agentId' => $this->accountId]);
    $selectedFilters = [
      'fromDate' => $this->fromDate,
      'toDate' => $this->toDate,
      'currency' => $this->currency,
      'accountId' => $this->accountId,
      'account' => $this->account,
    ];
    $this->dispatch('filtersApplied', ["filters" => $selectedFilters, "table_id" => "transaction-table"]);
    $this->dispatch('SetBalanceReconciliationAccountId', ['accountId' => $this->accountId]);
  }
  public function render()
  {
    return view('livewire.agent-panel.statement.filter');
  }
}
