<?php

namespace App\Livewire\AgentPanel\Transfer;

use App\Events\RefreshDataTable;
use App\Models\LedgerCashier;
use App\Models\LedgerTransfer;
use App\Services\Transfer\CashierLedgerService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Livewire\Component;

class HandleCashierBooking extends Component
{
    protected  function getListeners()
    {
        return [
            'PayTransfer' => 'PayTransfer',
            'CollectTransfer' => 'CollectTransfer',
            "ConfirmMessage" => "ConfirmMessage",
        ];
    }
    public  function ConfirmMessage($transfer_id, $emit = "payTransfer")
    {
        $main_transfer = LedgerTransfer::find($transfer_id);
        if ($emit == "PayTransfer") {
            $receiver_name = $main_transfer->recipient_name;
            $amount = PriceFormat($main_transfer->delivery_amount, $main_transfer->currency);
            $message = __("alerts.areyousure_pay_transfer", ['amount' => $amount, "sender_name" => $receiver_name]);
        }
        if ($emit == "CollectTransfer") {
            $amount = PriceFormat($main_transfer->amount + $main_transfer->sender_fee, $main_transfer->currency);
            $sender_name = $main_transfer->client->name;
            $message = __("alerts.areyousure_collect_transfer", ['amount' => $amount, "sender_name" => $sender_name]);
        }

        $this->dispatch("areyousure", ['msg' => __("alerts.areyousure"), 'emitName' => $emit, 'action' => __("YES"), 'title' => $message, 'data' => ['transfer_id' => $transfer_id]]);
    }
    public function PayTransfer($data)
    {
        $transfer_id = $data['transfer_id'];
        $rootagent = auth()->guard('agent')->user()->agent->rootAgent();

        try {
            DB::transaction(function () use ($transfer_id, $rootagent) {
                $main_transfer = LedgerTransfer::find($transfer_id);
                if ($main_transfer->is_paid == 1) {
                    throw new \Exception(__("alerts.transfer_already_paid"));
                }

                $transfer = $main_transfer->toArray();
                $main_cash = $rootagent->getMainCashierAgent()->id ?? null;
                if (!$main_cash) {
                    throw new \Exception(__("alerts.cashier_not_found"));
                }

                $transfer['sender_id'] = $main_cash;
                $transfer['receiver_id'] = auth()->guard('agent')->user()->agent->id;
                $transfer['id'] = null;
                $transfer['notes'] = null;
                $transfer['type'] = "Booking";
                $transfer['customer_details'] = null;
                $transfer['reference'] = generateRandomTransferNumber("REC");

                $cashier_ledger = LedgerCashier::create($transfer);

                $service = new CashierLedgerService();
                $service->createCashierLedgerEntries($cashier_ledger, "pay");

                // mark paid inside the same transaction
                $main_transfer->update(['is_paid' => 1]);
            });

            $this->dispatch("UnBlockUI");
            $this->dispatch("RefreshYajraDatatable", ['table' => 'paytransfer-table']);
            $this->dispatch("RefreshDashboardStatistics");
            $this->dispatch("sweetalert:success", ['msg' => __("alerts.transfer_paid_successfully"), "title" => "Success", "type" => "success"]);
        } catch (\Exception $exception) {
            Log::error($exception);
            $this->dispatch("UnBlockUI");
            $this->dispatch("sweetalert:error", ['msg' => $exception->getMessage(), "title" => "Error", "type" => "error"]);
        }
    }

    public  function  CollectTransfer($data)
    {
        $transfer_id = $data['transfer_id'];
        $rootagent = auth()->guard('agent')->user()->agent->rootAgent();
        try {
            DB::beginTransaction();
            $main_transfer = LedgerTransfer::find($transfer_id);
            $main_cash = $rootagent->getMainCashierAgent()->id ?? null;
            if (!$main_cash) {
                $this->dispatch("UnBlockUI");
                $this->dispatch("sweetalert:error", ['msg' => __("alerts.cashier_not_found"), "title" => "Error", "type" => "error"]);
                return;
            }
            $transfer = $main_transfer->toArray();
            if ($main_transfer->is_collected == 1) {
                $this->dispatch("UnBlockUI");
                $this->dispatch("sweetalert:error", ['msg' => __("alerts.transfer_already_collected"), "title" => "Error", "type" => "error"]);
                return;
            }
            $transfer['sender_id'] = auth()->guard('agent')->user()->agent->id;
            $transfer['receiver_id'] = $main_cash;
            $transfer['id'] = null;
            $transfer['notes'] = null;
            $transfer['type'] = "Booking";
            $transfer['customer_details'] = null;
            $transfer['reference'] = generateRandomTransferNumber("REC");

            $cashier_ledger = LedgerCashier::create($transfer);
            $service = new CashierLedgerService();

            $service->createCashierLedgerEntries($cashier_ledger, "collect");
            $main_transfer->update(['is_collected' => 1]);
            DB::commit();
            $this->dispatch("UnBlockUI");

            $this->dispatch("RefreshYajraDatatable", ['table' => 'collecttransfer-table']);

            $this->dispatch("RefreshDashboardStatistics");
            $this->dispatch("sweetalert:success", ['msg' => __("alerts.transfer_collected_successfully"), "title" => "Success", "type" => "success"]);
        } catch (\Exception $exception) {
            DB::rollBack();
            Log::info($exception);
            $this->dispatch("UnBlockUI");
            $this->dispatch("sweetalert:error", ['msg' => $exception->getMessage(), "title" => "Error", "type" => "error"]);
        }
    }
    public function render()
    {
        return view('livewire.agent-panel.transfer.handle-cashier-booking');
    }
}
