<?php

namespace App\Livewire;

use App\Models\Agent;
use App\Models\Currency;
use Illuminate\Support\Facades\Log;
use Livewire\Component;

class AgentSypRates extends Component
{
    public Agent $agent;
    public $currencies;
    public $rates = []; // stores agent_id => currency_code => settings

    public function updatedRates($value, $name)
    {
        // Remove "rates." from the start
        if (str_starts_with($name, 'rates.')) {
            $name = substr($name, 6); // remove "rates."
        }

        $parts = explode('.', $name);

        // We expect exactly: agentId.currencyCode.field
        if (count($parts) !== 3) {
            return; // Ignore invalid updates
        }

        [$agentId, $currencyCode, $field] = $parts;

        if (in_array($field, ['sell', 'buy_input', 'buy_mode', 'enabled'])) {
            $sellPrice = $this->rates[$agentId][$currencyCode]['sell'] ?? 0;
            $buyInput  = $this->rates[$agentId][$currencyCode]['buy_input'] ?? 0;
            $buyMode   = $this->rates[$agentId][$currencyCode]['buy_mode'] ?? 'absolute';

            $finalBuyPrice = ($buyMode === 'difference')
                ? $sellPrice + $buyInput
                : $buyInput;

            \App\Models\AgentSypRate::updateOrCreate(
                [
                    'agent_id' => $agentId,
                    'currency_code' => $currencyCode,
                ],
                [
                    'sell_price' => $sellPrice,
                    'buy_price'  => $finalBuyPrice,
                    'enabled'    => $this->rates[$agentId][$currencyCode]['enabled'] ?? false,
                ]
            );

            $this->rates[$agentId][$currencyCode]['buy'] = $finalBuyPrice;
        }
    }


    public function mount(Agent $agent)
    {
        $this->agent = $agent;
        $this->currencies = Currency::get();
        foreach ($this->currencies as $currency) {
            $rate = $this->agent->sypRates->firstWhere('currency_code', $currency->code);

            if ($rate) {
                Log::info("Currency {$currency->code} rate: ", [
                    'buy_price_mode' => $rate->buy_price_mode,
                    'buy_price_diff' => $rate->buy_price_diff,
                    'buy_price' => $rate->buy_price,
                ]);
            }

            $buy_price_mode = $rate->buy_price_mode ?? 'difference';

            $this->rates[$this->agent->id][$currency->code] = [
                'enabled'   => $rate->enabled ?? false,
                'sell'      => $rate->sell_price ?? 0,
                'buy_input' => $rate
                    ? ($buy_price_mode === 'difference' ? $rate->buy_price_diff : $rate->buy_price)
                    : 0,
                'buy_mode'  => $rate->buy_price_mode ?? 'actual',
                'buy'       => $rate->buy_price ?? 0,
            ];
        }
    }
    public function render()
    {
        return view('livewire.agent-syp-rates');
    }
}
