<?php

namespace App\Livewire\Api;

use App\Models\Agent;
use App\Models\ApiConfig;
use App\Models\ApiType;
use App\Models\ExternalAgent;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Livewire\WithFileUploads;

class ApiConfigManager extends Component
{
    public $apiTypes = [];
    public $showModal = false;
    public $selectedApiType;
    public $formFields = [];
    public $formData = [];
    public $name = "";
    public $agents;
    public $agentId;
    public  $externalAgents = [];
    public $selectedAgents = [];
    public $configs;
    public $editingId = null;
    public $avatar;
    use WithFileUploads;
    #[Validate('mimes:jpeg,png,jpg,pdf|max:1024')] // 1MB Max

    public function UploadAvatar($config)
    {
        if ($this->avatar) {
            $config->clearMediaCollection('logo');
            $config
                ->addMedia($this->avatar->getRealPath())
                ->usingFileName($this->avatar->getClientOriginalName())
                ->toMediaCollection('logo');
        }
    }
    public function mount()
    {
        $this->agents = Agent::where("type", "agent")->orWhere("type", "account")->get();
        $this->apiTypes = ApiType::all();
        $this->loadConfigs();
    }
    public function loadConfigs()
    {
        $this->configs = ApiConfig::with('agent', 'apiType')->get();
    }

    public function editConfig($id)
    {
        $this->editingId = $id;
        $config = ApiConfig::findOrFail($id);
        $this->avatar = $config->getFirstMedia('logo');
        $this->selectedApiType = $config->apiType;
        $this->agentId = $config->agent_id;
        $this->name = $config->name;
        $this->formFields = $this->selectedApiType->config_fields;
        $this->formData = json_decode($config->config_json, true);
        $this->getAllAgents($id);
        $this->loadSelectedAgents();
        $this->avatar = $config->getFirstMedia('logo');
        $this->dispatch("open_modal", ['action' => "show", 'id' => "APIConfigModal"]);
    }

    public function deleteConfig($id)
    {
        ApiConfig::findOrFail($id)->delete();
        $this->loadConfigs();
    }

    public function testConnection($id)
    {
        $config = ApiConfig::with('apiType')->findOrFail($id);
        $class = $config->apiType->class_name;



        $service = new $class();
        $configArray = json_decode($config->config_json, true);
        $configArray['base_url'] = $config->base_url;


        $service->setConfig($configArray);

        if (!($service instanceof \App\Interfaces\PartnerApiInterface)) {
            $this->dispatch("sweetalert:error", ['msg' => '❌ Class does not implement PartnerApiInterface.', 'title' => 'Error']);
            return;
        }

        $result = $service->testConnection();
        $clients = $service->getAllClients();

        $this->dispatch("sweetalert:success", ['msg' => $result ? '✅ Connection successful.' : '❌ Failed to connect.']);
        session()->flash('message', $result ? '✅ Connection successful.' : '❌ Failed to connect.');
    }

    public function getAllAgents($id)
    {
        $config = ApiConfig::with('apiType')->findOrFail($id);
        $class = $config->apiType->class_name;



        $service = new $class();
        $configArray = json_decode($config->config_json, true);
        $configArray['base_url'] = $config->base_url;

        $service->setConfig($configArray);

        if (!($service instanceof \App\Interfaces\PartnerApiInterface)) {
            $this->dispatch("sweetalert:error", ['msg' => '❌ Class does not implement PartnerApiInterface.', 'title' => 'Error']);
            return;
        }


        $this->externalAgents = $service->getAllClients();
    }

    public function openModal($apiTypeId)
    {
        $this->selectedApiType = ApiType::findOrFail($apiTypeId);
        $this->formFields = $this->selectedApiType->config_fields;
        $this->formData = [];
        $this->agentId = null;
        $this->dispatch("open_modal", ['action' => "show", 'id' => "APIConfigModal"]);
    }
    public function toggleExternalAgent($externalId)
    {
        $apiConfigId = $this->editingId; // assuming you're editing this config

        // First, find the agent in the externalAgents array to get more details
        $agentData = collect($this->externalAgents)->firstWhere('id', $externalId);

        if (!$agentData || !$apiConfigId) {
            $this->dispatch("sweetalert:error", ['msg' => "Invalid agent or config."]);
            return;
        }

        $existing = ExternalAgent::where('external_id', $externalId)
            ->where('source_id', $apiConfigId)
            ->first();

        if ($existing) {
            $existing->delete();
            $this->dispatch("sweetalert:success", ['msg' => "❌ Agent removed."]);
        } else {
            ExternalAgent::create([
                'external_id' => $externalId,
                'name'        => $agentData['name'] ?? $agentData['text'] ?? 'Unnamed',
                'phone'       => $agentData['phone'] ?? null,
                'country'     => $agentData['country'] ?? null,
                'currency'    => $agentData['currency'] ?? null,
                'source_id'   => $apiConfigId,
                'agent_id'    => null, // You can later add logic to link to local agent
            ]);
            $this->dispatch("sweetalert:success", ['msg' => "✅ Agent added."]);
        }

        $this->loadSelectedAgents(); // refresh toggle status
    }
    public function  loadSelectedAgents()
    {
        $this->selectedAgents = ExternalAgent::where('source_id', $this->editingId)
            ->pluck('external_id')
            ->toArray();
    }



    public function save()
    {
        // $this->validate([
        //     'agentId' => 'required|exists:agents,id',
        // ]);

        // foreach ($this->formFields as $field) {
        //     if (empty($this->formData[$field])) {
        //         $this->addError($field, "$field is required.");
        //         return;
        //     }
        // }

        $res = ApiConfig::updateOrCreate(
            [
                'agent_id' => $this->agentId,
                'api_type_id' => $this->selectedApiType->id
            ],
            [
                'name' => $this->name ?? null,
                'base_url' => $this->formData['base_url'] ?? null,
                'config_json' => json_encode($this->formData),
                'active' => true,
            ]
        );
        $this->UploadAvatar($res);
        $this->getAllAgents($res->id);

        $this->dispatch("sweetalert:success", ['msg' => __('alerts.saved_successfully')]);
    }


    public function render()
    {
        return view('livewire.api.api-config-manager');
    }
}
