<?php

namespace App\Livewire\AuditLogs;

use Livewire\Component;
use OwenIt\Auditing\Models\Audit;

class Details extends Component
{
  public $auditId = null;
  public $audit = null;
  public $showModal = false;

  protected function getListeners()
  {
    return ['showAuditDetails' => 'showDetails'];
  }

  public function showDetails($auditId)
  {

    $this->auditId = $auditId;
    $this->audit = Audit::with(['user', 'auditable'])->find($auditId);
    $this->showModal = true;
  }

  public function closeModal()
  {
    $this->showModal = false;
    $this->audit = null;
    $this->auditId = null;
  }

  public function render()
  {
    return view('livewire.audit-logs.details');
  }
}
