<?php

namespace App\Livewire\Client;

use App\Models\Client;
use Livewire\Component;

class ShowInfo extends Component
{
    public  $client;
    public  $address;
    public $avatar = null;
    protected function getListeners()
    {
        return [
            'getClientData' => 'LoadClientData',
            'ResetClientInfo' => 'ResetClientInfo',
            "LoadClientData" => "LoadClientData"
        ];
    }

    public function ResetClientInfo()
    {
        $this->client = null;
        $this->address = null;
        $this->avatar = null;
    }

    public  function LoadClientData($id)
    {

        $client = Client::find($id['id']);
        $this->client = $client;
        $this->address = $client->getPrimaryAddress()->toArray();
        $this->avatar = $client->getAvatar();
        //  $this->dispatch('editForm');
    }
    public function render()
    {
        return view('livewire.client.show-info');
    }
}
