<?php

namespace App\Livewire\Client;

use App\Models\Client;
use Livewire\Component;

class View extends Component
{
    public $showViewModal = false;
    public $client;
    public $address;
    protected function getListeners()
    {
        return [
            'viewClient' => 'viewClient'
        ];
    }
    public array $mediaFiles = []; // ✅ Always an empty array by default


    public function loadMedia(): void
    {
        $this->mediaFiles = [];

        $client = $this->client;

        if ($client) {
            // Group all media by collection name
            foreach ($client->media->groupBy('collection_name') as $collectionName => $mediaItems) {
                $this->mediaFiles[$collectionName] = $mediaItems->map(function ($media) {
                    return [
                        'id'       => $media->id,
                        'name'     => __($media->custom_properties['type'] ?? $media->name),
                        'url'      => $media->getFullUrl(),
                        'download' => $media->getFullUrl(),
                        'mime'     => $media->mime_type ?? '', // ✅ Avoid undefined array key
                    ];
                })->toArray();
            }
        } else {
            $this->mediaFiles = []; // ✅ Reset to empty if not found
        }
    }
    public function viewClient($clientId)
    {

        $this->client = Client::with('address')->findOrFail($clientId);
        $this->address = $this->client->address ?? null;
        $this->loadMedia();
        $this->dispatch("open_modal", ['action' => 'show', 'id' => 'ClientDetailsModal']);
    }
    public function render()
    {
        return view('livewire.client.view');
    }
}
