<?php

namespace App\Livewire\Components;

use App\Models\Account;
use Livewire\Component;

class AddReduceBalance extends Component
{
    public $action_type = 'Add';
    public  $type_title = "Add Balance";
    public  $accounts;
    public $account, $account_id, $currency, $amount, $description;
    public $banktransaction;
    protected  function getListeners()
    {
        return
            [
                'BanktransactionTypeChanged' => 'BanktransactionTypeChanged'
            ];
    }
    public function BanktransactionTypeChanged($payload)
    {


        $id = $payload['id'] ?? null;
        $type = $payload['type'] ?? null;


        if ($type == 2 || $type == 5) {
            $type == 2 ? $this->action_type = "Reduce" : $this->action_type = "Add";
            if ($type == 2) {
                $this->type_title = "Reduce Balance";
            }
            $banktransaction = \App\Models\BankTransaction::find($id);
            $banktransaction->type = $type;
            if ($banktransaction->status == "approved" && $banktransaction->balance <= 0) {
                $this->dispatch("sweetalert:error", [
                    'title' => 'Error',
                    'msg' => 'Payment already approved',
                ]);
                return;
            }
            $this->banktransaction = $banktransaction;


            $this->amount = $banktransaction->amount;
            $this->description = $banktransaction->description;

            $this->dispatch("open_modal", ['action' => "show", 'id' => "AddReduceBalance"]);
        }
    }
    public function UpdatedAccountId()
    {
        $account = Account::find($this->account_id);
        $this->currency = $account->currency;
        $this->account = $account;
    }
    public function AddReduceBalance()
    {
        $rules = [
            'account_id' => 'required',
            'amount' => 'required',
            'action_type' => 'required',
        ];
        $this->validate($rules);
        $account = $this->account;
        switch ($this->action_type) {
            case 'Add':
                $account->deposit($this->amount, [
                    'action' => 'Add Balance',
                    'description' => $this->description,
                    'from_old_balance' => $account->balance,
                    'to_old_balance' => $account->balance
                ]);

                break;
            case 'Reduce':
                if ($this->banktransaction && $this->amount != $this->banktransaction->amount) {
                    $this->dispatch("sweetalert:error", [
                        'title' => 'Error',
                        'msg' => 'Amount does not match',
                    ]);
                    return;
                }
                if (!$this->banktransaction) {
                    if ($account->balance < $this->amount) {
                        $this->dispatch("sweetalert:error", [
                            'title' => 'Error',
                            'msg' => 'Insufficient balance',
                        ]);
                        return;
                    }
                    $account->withdraw($this->amount, [
                        'action' => 'Reduce Balance',
                        'from_old_balance' => $account->balance,
                        'to_old_balance' => $account->balance,
                        'description' => $this->description
                    ]);
                } else {
                    $account->forcewithdraw(abs($this->amount), [
                        'action' => 'Reduce Balance',
                        'from_old_balance' => $account->balance,
                        'to_old_balance' => $account->balance,
                        'description' => $this->description
                    ]);
                }
                break;
        }
        if ($this->banktransaction) {
            $this->banktransaction->update([
                'status' => 'approved',
                'account_id' => $this->account_id
            ]);
            $this->banktransaction->save();
            $this->banktransaction->forcewithdraw(abs($this->amount), [
                'action' => 'Reduce Balance',
                'from_old_balance' => $this->banktransaction->balance,
                'to_old_balance' => $this->banktransaction->balance,
                'description' => $this->description
            ]);
        }
        $this->dispatch("sweetalert:success", [
            'title' => 'Success',
            'msg' => 'Balance Updated Successfully',
        ]);

        $this->dispatch("open_model", ['action' => "hide", 'id' => "AddReduceBalance"]);
        $this->dispatch("UpdateAccountsList");
        $this->dispatch("RefreshYajraDatatable", [
            'table' => 'banktransaction-table',
        ]);
    }
    public  function  mount()
    {
        $this->accounts = Account::get();
    }
    public function render()
    {
        return view('livewire.components.add-reduce-balance');
    }
}
