<?php

namespace App\Livewire\Components;

use App\Models\Property;
use App\Models\Rent;
use App\Models\Tenant;
use App\Models\User;
use Carbon\Carbon;
use Livewire\Component;

class Contract extends Component
{
    public $tenant, $tenants;
    public  $property;
    public $contract, $rent;
    public $rental_types = [];
    public $overdue = [];
    public  $properties;
    public  $model, $selected_contract;
    public  $contracts;
    public  $contract_terminate_date;
    public  $contract_terminate_reason;
    public  $conditions;
    public $repeaterResponses = 0, $expectedRepeaters = 1;
    public array $conditionsFields = [
        ['name' => 'order', 'text' => ['tr' => 'Numara', 'en' => 'Number']], //'Name'],
        ['name' => 'clause', 'text' => ['tr' => 'DEĞER', 'en' => 'VALUE']], //'Value'],
    ];
    public function handleRepeaterData($prefix, $data)
    {
        $this->$prefix = $data;
        $this->repeaterResponses++;

        if ($this->repeaterResponses === $this->expectedRepeaters) {
            $this->SaveConditions();
        }
    }
    public  function SaveConditions()
    {
        $contract = $this->contract;
        $contract->leaseConditions()->delete();
        $contract->leaseConditions()->createMany($this->conditions);
        $this->dispatch("sweetalert:success", ['msg' => 'Conditions updated successfully', 'title' => 'Success']);
    }
    public function UpdatedSelectedContract()
    {
        $this->validate([
            'selected_contract' => 'required'
        ]);
        $contract = \App\Models\Contract::with("property", "tenant", "rent")->find($this->selected_contract);
        $this->contract = $contract;

        $this->rent = $contract->rent;
    }

    public function ChangeContractStatus()
    {
        // Determine if contract is currently active based on logic
        $isCurrentlyActive = is_null($this->contract->terminated_at) && $this->contract->contract_end > now();

        // If currently active → Ask admin to confirm termination
        if ($isCurrentlyActive) {
            $this->dispatch("open_modal", [
                "id" => "ChangeContractStatusModal",
                "action" => "show"
            ]);
        } else {
            // Reactivate
            $this->contract->status = 1;
            $this->contract->terminated_at = null;
            $this->contract->terminate_reason = null;
            $this->contract->save();

            $this->dispatch("sweetalert:success", [
                'icon' => 'success',
                'title' => __('Contract Status Changed'),
                'msg' => __('Contract has been reactivated'),
            ]);
        }
    }
    public  function TerminateContract()
    {
        $contract = $this->contract;
        $status = !$this->contract->status;

        $this->contract->status = $status;
        $this->contract->terminated_at = $this->contract_terminate_date;
        $this->contract->terminate_reason = $this->contract_terminate_reason;
        $this->contract->save();
        $this->dispatch("open_modal", [
            "id" => "ChangeContractStatusModal",
            "action" => "hide"
        ]);
        $this->dispatch("sweetalert:success", [
            'icon' => 'success',
            'title' => __('Contract Status Changed'),
            'msg' => __('Contract Status Changed'),
        ]);
    }
    public function PrintContract()
    {
        $contract = $this->contract;
        $pageConfigs = ['myLayout' => 'blank'];
        return view('Contract.print', ['pageConfigs' => $pageConfigs]);
    }
    public function mount()
    {

        $contract = $this->model->contracts()->first();
        $this->selected_contract = $contract->id ?? null;
        $this->contracts = $this->model->contracts;
        $this->contract = $contract;

        $this->rental_types = Rent::getTypes();
        $this->tenants = Tenant::get();
        $this->tenant = $this->contract->tenant ?? null;
        $this->property = $this->contract->property ?? null;
        $this->rent = $this->contract->rent ?? null;
        $this->contract_terminate_date = $this->contract->contract_end ?? Carbon::today()->format('Y-m-d');
        $this->conditions = optional(optional($this->contract)->resolvedLeaseConditions())->toArray() ?? [];
    }
    public function render()
    {
        return view('livewire.components.contract');
    }
}
