<?php

namespace App\Livewire\Components;

use App\Models\Facility;
use Livewire\Component;

class Features extends Component
{
    public $features, $selected_features = [], $select_all = false;
    public $feature_name;
    public  $model;
    public $modelid;
    public function render()
    {
        return view('livewire.components.features');
    }
    public function UpdatedSelectAll($value)
    {
        if ($value) {
            $this->selected_features = array_column($this->features, 'id');
        } else {
            $this->selected_features = [];
        }
    }

    public function AddFeature()
    {

        $rules = [
            'feature_name' => 'required',
        ];
        $this->validate($rules);
        $name = $this->feature_name;
        $facility = Facility::create([
            'name' => $name,
        ]);
        $this->features[] = $facility;
        $this->selected_features[] = $facility['id'];
        $this->feature_name = null;
    }
    public  function SaveFeatures()
    {
        $this->validate([
            'selected_features' => 'required',
        ]);
        $this->model->facilities()->sync($this->selected_features);
        $this->dispatch("sweetalert:success", ['msg' => 'Facilities updated successfully', 'title' => 'Success']);
    }
}
