<?php

namespace App\Livewire\Components;

use Livewire\Component;
use Livewire\Attributes\On;

class Notes extends Component
{
    public  $className;
    public $notes = [];
    public $note_name;
    public $class_id;
    public  $user;
    protected function getListeners()
    {
        return [
            'DeleteNote' => 'Delete',
            'refreshNotes' => 'mount',
        ];
    }
    public function Delete($data)
    {
        $note_id = $data['id'];
        $instance = $this->className::find($this->class_id);
        $instance->notes()->where('id', $note_id)->delete();
        $this->notes = $instance->notes()->get();
    }

    public function AddNote()
    {
        $user_id = auth()->user()->id;
        $this->notes[] = [
            'note' => $this->note_name,
        ];
        $instance = $this->className::find($this->class_id);

        $instance->notes()->create([
            'note' => $this->note_name,
            'user_id' => $user_id,
        ]);
        $this->notes = $instance->notes()->get();
        $this->note_name = null;
    }
    public  function  deleteNote($note_id)
    {
        $this->dispatch('areyousure', ['msg' => "Are you sure you want to delete this note?", 'emitName' => 'DeleteNote', 'action' => "Delete", 'title' => "Delete Note", 'data' => ['id' => $note_id]]);
    }

    public function mount()
    {
        $this->user = auth()->user();
        $this->notes = $this->className::find($this->class_id)->notes()->get();
    }
    public function render()
    {
        return view('livewire.components.notes');
    }
}
