<?php

namespace App\Livewire\Components;

use App\Models\Account;
use Livewire\Component;
use Worksome\Exchange\Facades\Exchange;

class Transfer extends Component
{
    public  $accounts;
    public  $from_account, $to_account, $amount;
    public $from_account_id, $to_account_id, $calculated_amount, $exchange_rate = 1;
    public $description;
    public $banktransaction;
    protected function  getListeners()
    {
        return [

            'BanktransactionTypeChanged' => 'BanktransactionTypeChanged'
        ];
    }
    public function BanktransactionTypeChanged($payload)
    {


        $id = $payload['id'] ?? null;
        $type = $payload['type'] ?? null;


        if ($type == 3) {

            $banktransaction = \App\Models\BankTransaction::find($id);
            $banktransaction->type = $type;
            $this->banktransaction = $banktransaction;
            if ($banktransaction->status == "approved" && $banktransaction->balance <= 0) {
                $this->dispatch("sweetalert:error", [
                    'title' => 'Error',
                    'msg' => 'Payment already approved',
                ]);
                return;
            }
            $this->amount = $banktransaction->amount;
            $this->description = $banktransaction->description;

            $this->dispatch("open_modal", ['action' => "show", "id" => "transferMoneyModal"]);
        }
    }
    public function  UpdatedFromAccountId()
    {
        $this->from_account = Account::find($this->from_account_id);


        $this->CalculateCurrency();
    }

    public function  UpdatedToAccountId()
    {
        $this->to_account = Account::find($this->to_account_id);

        $this->CalculateCurrency();
    }
    public function  Updated()
    {

        if (isset($this->amount) && $this->amount > 0) {
            $this->CalculateCurrency();
        }
    }
    public  function  CalculateCurrency()
    {
        $from_account =  $this->from_account;
        $to_account = $this->to_account;
        if (!isset($from_account) || !isset($to_account))
            return;
        if ($from_account->currency == $to_account->currency) {
            $this->calculated_amount = $this->amount;
            $this->exchange_rate = 1;
            return;
        }
        $from_currency = $from_account->currency;
        $to_currency = $to_account->currency;
        $exchangeRates = Exchange::rates($from_currency, [$to_currency]);
        $exchangeRate = $exchangeRates->getRates();
        $this->exchange_rate = $exchangeRate["$to_currency"];
        $this->calculated_amount = round($this->amount * $exchangeRate["$to_currency"], 2);
    }
    public function getFilteredAccounts($excludeId)
    {
        return collect($this->accounts)->map(function ($account) use ($excludeId) {
            return [
                'id' => $account->id,
                'name' => $account->name,
                'currency' => $account->currency,

            ];
        });
    }
    public function getAccountBalance($accountId)
    {
        $account = Account::find($accountId);
        return $account->balance;
    }
    public function getAccountCurrency($accountId)
    {
        $account = Account::find($accountId);
        return $account->currency;
    }
    public  function Transfer()
    {
        $from_account = $this->from_account;
        $to_account = $this->to_account;
        if ($from_account == $to_account) {
            $this->dispatch("sweetalert:error", [
                'title' => 'Error',
                'msg' => 'You cannot transfer to the same account',
            ]);

            return;
        }
        $balance = $from_account->balance;
        if (!isset($this->banktransaction) && $balance < $this->amount) {
            $this->dispatch("sweetalert:error", [
                'title' => 'Error',
                'msg' => 'Insufficient balance',
            ]);
            return;
        }
        try {
            $from_old_balance = $from_account->balance;
            $to_old_balance = $to_account->balance;
            if ($from_account->currency != $to_account->currency) {
                force_exchange_transfer($from_account, $to_account, $this->amount);
            } else {
                $from_account->forcetransfer($to_account, $this->calculated_amount, [
                    'action' => 'Transfer',
                    'description' => 'Transfer from ' . $from_account->name . ' to ' . $to_account->name,
                    'from_old_balance' => $from_old_balance,
                    'to_old_balance' => $to_old_balance,
                    'from_currency' => $from_account->currency,
                    'to_currency' => $to_account->currency,
                    'note' => $this->description
                ]);
            }
            if ($this->banktransaction) {
                $this->banktransaction->status = "approved";

                $this->banktransaction->save();
                $this->banktransaction->forcewithdraw($this->amount, ['description' => $this->description]);
            }
            $this->dispatch("UpdateAccountsList");
            $this->dispatch("RefreshYajraDatatable", [
                'table' => 'banktransaction-table',
            ]);
            $this->dispatch("sweetalert:success", [
                'title' => 'Success',
                'msg' => 'Transfer Successfully',
            ]);
            $this->dispatch("UpdateAccountsList");
        } catch (\Exception $e) {
            $this->dispatch("sweetalert:error", [
                'title' => 'Error',
                'msg' => $e->getMessage(),
            ]);
        }
    }
    public function mount()
    {
        $this->accounts = Account::get();
    }
    public function render()
    {
        return view('livewire.components.transfer');
    }
}
