<?php

namespace App\Livewire\Roles;

use App\Models\Permission;
use App\Models\Role;
use Livewire\Component;

class Add extends Component
{
    public $permissions;
    public  $permissionsArray = [];
    public $rolename;
    public $role;
    protected function getListeners()
    {
        return [
            "EditRole" => "EditRole"
        ];
    }
    public  function mount()
    {
        $this->permissions = Permission::get();
    }
    public function AddRole()
    {
        if (isset($this->role)) {
            $this->role->update(['name' => $this->rolename]);
            $this->role->permissions()->sync($this->permissionsArray);
        } else {
            $Role = Role::create(['name' => $this->rolename, 'guard_name' => 'web']);
            $Role->permissions()->sync($this->permissionsArray);
        }
        $this->rolename = '';
        $this->permissionsArray = [];
        $this->dispatch("sweetalert:success", ['msg' => "Role Added Successfully", "title" => "Success", "type" => "success"]);
        $this->dispatch("open_modal", ['action' => "hide", "id" => "addRoleModal"]);
        $this->dispatch("ReloadRoles");
    }
    public  function  EditRole($id)
    {
        $role = Role::find($id);
        $this->role = $role;
        $this->rolename = $role->name;
        $this->dispatch("open_modal", ['action' => "show", "id" => "addRoleModal"]);
    }

    public function render()
    {
        return view('livewire.roles.add');
    }
}
