<?php

namespace App\Livewire\Roles;

use App\Models\Permission;
use App\Models\PermissionTree;
use App\Models\Role;
use Livewire\Component;

class AddRole extends Component
{
    public $treesWithPermissions = [];
    public $selectedPermissions = [];
    public  $role_name;
    public $search;
    public $role_id;
    protected $messages = [
        'role_name.required' => 'Role name is required.',
    ];

    public function  mount()
    {
        $this->treesWithPermissions = PermissionTree::with('permissions')->get()->toArray();
        if ($this->role_id) {
            $role = Role::findorfail($this->role_id);
            $this->role_name = $role->name;
            $this->selectedPermissions = $role->permissions()->pluck('id')->toArray();
        }
    }
    public function  UpdatedSearch($value)
    {
        $this->treesWithPermissions = PermissionTree::where('name', 'LIKE', '%' . $this->search . '%')
            ->orWhereHas('permissions', function ($query) {
                $query->where('name', 'LIKE', '%' . $this->search . '%');
            })->with('permissions')->get()->toArray();
    }
    public function save()
    {

        $rules = ['role_name' => 'required'];
        $this->validate($rules);

        $role = $this->role_id ? Role::findOrFail($this->role_id) : new Role();
        $role->name = $this->role_name;
        $role->guard_name = 'web';
        $role->save();

        // ✅ Only get permissions that exist for 'web' guard
        $validPermissionIds = Permission::whereIn('id', $this->selectedPermissions)
            ->where('guard_name', 'web')
            ->pluck('id')
            ->toArray();

        $role->syncPermissions($validPermissionIds);
        $this->dispatch("sweetalert:success", ["msg" => "Role Saved Successfully"]);
    }
    public function render()
    {
        return view('livewire.roles.add-role');
    }
}
