<?php

namespace App\Livewire\Roles;

use App\Models\Role;
use Livewire\Component;

class Management extends Component
{
    public $roles;
    public $permissions = [];
    public  $rolename;
    public $role;
    protected function getListeners()
    {
        return [
            "ReloadRoles" => "ReloadRoles"
        ];
    }
    public  function AddRole()
    {
        $newRole = Role::create(['name' => $this->rolename]);
        $newRole->permissions()->sync($this->permissions);
    }
    public function editRole($id)
    {

        $this->dispatch("EditRole", $id);
    }
    public function ReloadRoles()
    {
        $this->roles = Role::get();
    }
    public function mount()
    {
        $this->roles = Role::get();
    }
    public function render()
    {
        return view('livewire.roles.management');
    }
}
