<?php

namespace App\Livewire\Settings\Tabs;

use Livewire\Component;
use Rawilk\Settings\Facades\Settings;

class Foundation extends Component
{
    public $accounts;
    public  $foundation = [
        'enable_revenue_distribution' => false,
        'distribution_strategy' => '',
        'distribution_source' => '',
        'when_to_distribute' => 'manual',
        'substract_expenses' => false

    ];
    public $strategies = ["Islamic", "Equal"];
    public function mount()
    {
        foreach ($this->foundation as $key => $default) {
            $this->foundation[$key] = Settings::get("foundation.$key", $default);
        }
        $this->accounts = \App\Models\Account::all();
    }
    public function  save()
    {
        foreach ($this->foundation as $key => $value) {
            Settings::set("foundation.$key", $value);
        }

        $this->dispatch("sweetalert:success", [
            'msg' => '  settings updated successfully',
            'title' => 'Success',
            'icon' => 'success'
        ]);
    }
    public function render()
    {
        return view('livewire.settings.tabs.foundation');
    }
}
