<?php

namespace App\Livewire\Settings\Tabs;

use Livewire\Component;
use Rawilk\Settings\Facades\Settings;

class SystemConfigs extends Component
{
    public $system = [
        'exchange_start_time' => 0,
        'exchange_end_time' => 24,
        'approval_start_time' => 0,
        'approval_end_time' => 24,
        'edit_booking_time' => 2
    ];
    public function saveSystemConfig()
    {
        foreach ($this->system as $key => $value) {
            Settings::set("system.$key", $value);
        }
        $this->dispatch("sweetalert:success", [
            'msg' => 'System settings updated successfully',
            'title' => 'Success',
            'icon' => 'success'
        ]);
    }
    public function mount()
    {
        foreach ($this->system as $key => $default) {
            $this->system[$key] = Settings::get("system.$key", $default);
        }
    }
    public function render()
    {
        return view('livewire.settings.tabs.system-configs');
    }
}
