<?php

namespace App\Livewire\Sms;

use App\Models\NotificationTemplate;
use App\Services\MessageTagParser;
use Livewire\Component;

class SmsTemplateEditor extends Component
{
    public string $template = '';
    public array $params = [];
    public string $preview = '';

    public function mount($templateId = null)
    {
        if ($templateId) {
            $model = NotificationTemplate::find($templateId);
            $this->template = $model?->body ?? '';
        }

        $this->params = [
            'account_name' => 'Ahmet',
            'balance' => '500.00',
            'date' => now()->format('Y-m-d'),
            'last_pay_day' => now()->addDays(7)->format('Y-m-d'),
            'currency' => 'TL',
            'pf_name' => 'Ankara Şube',
            'pr_building_number' => 'B-12',
            'contract_start_date' => now()->subYear()->format('Y-m-d'),
            'payment_day' => '15',
            'payment_link' => 'https://example.com/pay/12345',
        ];

        $this->generatePreview();
    }

    public function updatedTemplate()
    {
        $this->generatePreview();
    }

    public function generatePreview()
    {
        $parser = new MessageTagParser();
        $this->preview = $parser->parse($this->template, $this->params);
    }
    public function render()
    {
        return view('livewire.sms.sms-template-editor');
    }
}
