<?php

namespace App\Livewire\Templates;

use Livewire\Component;

class Add extends Component
{
    public $template = ['type' => 'transfer'];
    public $types = ['transfer', 'exchange', 'booking', 'delivery'];
    public $keys = [];
    protected  function getListeners()
    {
        return [
            'editTemplate' => 'editTemplate',
            'deleteTemplate' => 'deleteTemplate',
            'deleteAlert' => 'deleteAlert',
        ];
    }
    public  function mount()
    {
        $this->keys = getTemplateKeys($this->template['type']);
    }
    public function UpdatedTemplateType($type)
    {
        $this->template['type'] = $type;
        $this->keys = getTemplateKeys($this->template['type']);
    }
    public function deleteAlert($id)
    {
        $this->dispatch('areyousure', ['msg' => __("alerts.areyousure"), 'emitName' => 'deleteTemplate', 'action' => __("actions.delete"), 'title' => __("alerts.delete"), 'data' => ['id' => $id]]);
    }
    public function deleteTemplate($data)
    {
        try {
            $template = \App\Models\Template::find($data['id']);
            $template->delete();
            $this->dispatch("sweetalert:success", [
                'msg' => "Template deleted successfully.",
                'title' => __('Success'),
                'iconClass' => 'toast-success',
                'icon' => 'success',
            ]);
            $this->dispatch("RefreshYajraDatatable", ['table' => 'template-table']);
            $this->dispatch("sweetalert:success", ['msg' => __("alerts.deleted_successfully"), "title" => __("alerts.success"), "type" => "success"]);
        } catch (\Exception $e) {
            $this->dispatch("sweetalert:error", ['msg' => __('alerts.something_went_wrong'), "title" => "Error", "type" => "error"]);
        }

        $this->dispatch("UnBlockUI");
    }
    public function  editTemplate($id)
    {
        $template = \App\Models\Template::find($id);
        $this->template = $template->toArray();
        $this->dispatch("FillQuill", ['content' => $this->template['content']]);
    }
    public function store()
    {
        $this->validate([
            'template.name' => 'required',
            'template.content' => 'required',
        ]);
        try {
            if (isset($this->template['id'])) {
                $template = \App\Models\Template::find($this->template['id']);
                $template->update($this->template);
                $this->dispatch("sweetalert:success", [
                    'msg' => "Template updated successfully.",
                    'title' => __('Success'),
                    'iconClass' => 'toast-success',
                    'icon' => 'success',
                ]);
                return;
            }
            $template = \App\Models\Template::create($this->template);
            $this->dispatch("sweetalert:success", [
                'msg' => "Template saved successfully.",
                'title' => __('Success'),
                'iconClass' => 'toast-success',
                'icon' => 'success',
            ]);
        } catch (\Exception $e) {
            $this->dispatch("sweetalert:error", ['msg' => __('alerts.something_went_wrong'), "title" => "Error", "type" => "error"]);
        }
    }
    public function render()
    {
        return view('livewire.templates.add');
    }
}
