<?php

namespace App\Livewire\Transfer;

use App\Models\LedgerTransfer;
use Livewire\Component;

class TransferInfo extends Component
{
  public $transfer_id;
  public $transfer;
  protected function getListeners()
  {
    return [
      "setTransferId" => "setTransferId",
      "RefreshTransferInfo" => "RefreshTransferInfo",
    ];
  }
  public function setTransferId($id)
  {


    $this->transfer_id = $id;
    $this->transfer = LedgerTransfer::withoutGlobalScopes()->withTrashed()->find($id);
    $this->dispatch("open_modal", ['action' => "show", "id" => "TransferInfoModal"]);
  }
  public function RefreshTransferInfo($id)
  {
    $this->transfer = LedgerTransfer::withoutGlobalScopes()->withTrashed()->where("id", $id)->first();
  }
  public function render()
  {
    return view('livewire.transfer.transfer-info');
  }
}
