<?php

namespace App\Livewire\Transfers;

use App\Models\LedgerTransfer;
use Livewire\Component;

class ShowDetails extends Component
{
  public $transfer_id;
  public $transfer;

  protected function getListeners()
  {
    return [
      'showTransferDetails' => 'showTransferDetails',
    ];
  }

  public function showTransferDetails($transfer_id)
  {

    $this->transfer_id = $transfer_id;
    $this->transfer = LedgerTransfer::with('sender', 'receiver', 'client')->find($transfer_id);
    $this->dispatch("open_modal", [
      'title' => 'Show Details',
      'content' => 'showTransferDetails',
      'id' => 'showTransferDetails',
      'action' => "show"
    ]);
  }


  public function render()
  {
    return view('livewire.transfers.show-details');
  }
}
