<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class AgentGlobalCreditLimit extends Model
{
  protected $fillable = [
    'agent_id',
    'base_currency_code',
    'base_credit_limit',
    'approval_credit_limit',
    'transfer_status',
    'approval_status',
    'send_transfer',
    'send_approval',

  ];
  protected $casts = [

    'transfer_status' => 'boolean',
    'approval_status' => 'boolean',
    'send_transfer' => 'boolean',
    'send_approval' => 'boolean',
    'base_credit_limit' => 'integer',
    'approval_credit_limit' => 'integer',
  ];
  protected static function booted()
  {
    static::saved(function ($model) {
      Cache::forget("agent_{$model->agent_id}_transfer_global_credit_limit");
    });

    static::deleted(function ($model) {
      Cache::forget("agent_{$model->agent_id}_transfer_global_credit_limit");
    });
  }
  public function  agent()
  {
    return $this->belongsTo(Agent::class);
  }
}
