<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AgentSypRate extends Model
{
    protected $fillable = [
        'agent_id',
        'currency_code',
        'enabled',
        'sell_price',
        'buy_price',
    ];

    protected $casts = [
        'enabled' => 'boolean',
        'sell_price' => 'decimal:2',
        'buy_price' => 'decimal:2',
    ];
    public function agent()
    {
        return $this->belongsTo(Agent::class);
    }
    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_code', 'code');
    }
}
