<?php

namespace App\Models;

use Abivia\Ledger\Models\LedgerAccount;
use Abivia\Ledger\Models\LedgerBalance;
use Illuminate\Database\Eloquent\Model;

class BalanceOverwrite extends LedgerBalance
{
    protected $table = 'ledger_balances';
    public function  account()
    {
        return $this->belongsTo(CustomLedgerAccount::class, 'ledgerUuid', 'ledgerUuid');
    }
    public function scopePositive($query)
    {
        return $query->where('balance', '>', 0);
    }

    public function scopeNegative($query)
    {
        return $query->where('balance', '<', 0);
    }
    public  function  mainCurrency()
    {
        return $this->belongsTo(Currency::class, 'currency', 'code');
    }

    public function getFormattedBalanceAttribute()
    {
        return number_format($this->balance, 2) . ' ' . $this->currency;
    }
}
