<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $fillable = ['name', 'parent_id', 'ledger_account_code'];

    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }



    public function ledgerAccount()
    {
        return $this->hasOne(\Abivia\Ledger\Models\LedgerAccount::class, 'code', 'ledger_account_code');
    }
}
