<?php

namespace App\Models;

use App\Traits\CustomAuditable;
use Illuminate\Database\Eloquent\Model;
use Rawilk\Settings\Facades\Settings;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Support\Arr;

class Exchange extends Model  implements Auditable
{
    use \OwenIt\Auditing\Auditable, CustomAuditable;
    protected $fillable = [
        'from_currency',
        'to_currency',
        'rate',
        'rate_factor',
        'from_amount',
        'to_amount',
        'agent_id',
        'reference'
    ];
    protected $casts = [

        'rate' => 'decimal:6',

        'created_at' => 'datetime:d-m-Y H:i:s',
    ];
    public  function agent()
    {
        return $this->belongsTo(Agent::class);
    }
    public  function getParsedReceipt()
    {
        $type = "exchange";
        $template_id = Settings::get("default_template.$type");
        $template = Template::find($template_id);
        $html = $template->content;
        $companyName = Settings::get('general.company_name');
        $logo =  '/storage/Logo/' . Settings::get('logo', null);

        return str_replace([
            '%company_name%',
            '%logo%',
            '%date%',
            '%agent_id%',
            '%reference%',
            '%from_amount%',
            '%from_currency%',
            '%to_amount%',
            '%to_currency%',
            '%notes%',

            '%agent_address%',
            '%created_at%',




        ], [
            $companyName, // Or get from DB
            "<img src=\"$logo\" alt=\"Logo\" class=\"img-fluid mt-2 embed-responsive\" style=\"max-width: 100px; max-height: 100px;\" />",
            $this->created_at->format('Y-m-d H:i:s'),
            $this->agent->name ?? "",
            $this->reference,
            format_money($this->from_amount, $this->from_currency),
            $this->from_currency,
            format_money($this->to_amount,  $this->to_currency),
            $this->to_currency,
            $this->notes,
            $this->agent->getFullAddress() ?? '',
            format_money($this->amount, "USD"),




        ], $html);
    }
    public function transformAudit(array $data): array
    {

        if (Arr::has($data, 'new_values.from_amount')) {

            $data['new_values']['from_amount'] = format_money($this->from_amount, $this->from_currency);
        }
        if (Arr::has($data, 'new_values.to_amount')) {

            $data['new_values']['to_amount'] = format_money($this->to_amount, $this->to_currency);
        }




        return $data;
    }
}
