<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormFieldConfig extends Model
{
    protected $table = 'form_field_configs';

    protected $fillable = [
        'form_name',
        'field',
        'label',
        'visible',
        'required',
        'extra',
        'tab_index',
        'always_required',   // <--- add here
    ];

    protected $casts = [
        'visible' => 'boolean',
        'required' => 'boolean',
        'extra' => 'array',
    ];

    public static function forForm(string $formName): \Illuminate\Support\Collection
    {
        return self::where('form_name', $formName)
            ->orderBy('id') // or any other order
            ->get()
            ->keyBy('field'); // so you can do $config['transfer.sender_id']
    }
}
