<?php

namespace App\Models;

use Abivia\Ledger\Models\JournalDetail;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class JournalDetailOverwrite extends JournalDetail
{
  protected $table = "journal_details";
  public function entry(): BelongsTo
  {
    return $this->belongsTo(
      JournalEntryOverwrite::class,
      'journalEntryId',
      'journalEntryId'
    );
  }
  public function account(): BelongsTo
  {
    return $this->belongsTo(\App\Models\LedgerAccountOverwrite::class, 'ledgerUuid', 'ledgerUuid');
  }
}
