<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class Shortcut extends Model implements HasMedia
{
    use InteractsWithMedia;

    protected $fillable = ['name', 'url', 'user_id'];

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('icon')
            ->singleFile(); // only keep latest uploaded icon
    }


    public function registerMediaConversions(?Media $media = null): void
    {
        $this->addMediaConversion('thumb')

            ->background('ffffff')
            ->sharpen(10)
            ->quality(90)
            // ->withManipulations([
            //     'border-radius' => '100%', // not always supported, see below
            // ])
            ->nonQueued();
    }
}
