<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TransferPackage extends Model
{
    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];
    protected $fillable = ['type', 'currency',   'name'];
    public function details()
    {
        return $this->hasMany(TransferPackageDetail::class, 'package_id');
    }

    // Many-to-many with agents
    public function agents()
    {
        return $this->belongsToMany(Agent::class, 'agents_transfer_packages', 'package_id', 'agent_id');
    }
    public function agentOverrides()
    {
        return $this->hasMany(AgentTransferPackageDetail::class);
    }
    public  function ScopeTransfer($query)
    {
        return $query->where("type", "transfer");
    }
    public function ScopeApproval($query)
    {
        return $query->where("type", "approval");
    }
}
