<?php

namespace App\Observers;

use App\Events\RefreshDataTable;
use App\Services\Transfer\ApprovalService;

use Illuminate\Support\Facades\Auth;

class ApprovalObserver
{

    public function  created($transfer)
    {
        $service = new ApprovalService();

        $service->createTransferLedgerEntries($transfer);
        // $description = generateTransferDescription($transfer);
        // $old_desc = $transfer->notes;
        // $transfer->notes = $old_desc . " " . $description;
        // $transfer->save();
        event(new RefreshDataTable("approval-table"));
    }
    public function creating($transfer)
    {
        $transfer->user_id = Auth::user()->id ?? 1;
    }
}
