<?php

namespace App\Observers;

use App\Models\Currency;
use App\Services\Transfer\ExchangeService;
use Illuminate\Container\Attributes\Log;
use Illuminate\Support\Facades\Log as FacadesLog;

class ExchangeObserver
{

    public function  created($exchange)
    {
        $default_currency = Currency::where('default', 1)->first();
        $default = $default_currency->code;
        $service = new ExchangeService();
        if ($exchange->from_currency == $default) {

            $service->CreateSellingExchangeLedgerEntries($exchange);
        } elseif ($exchange->from_currency != $default && $exchange->to_currency == $default) {
            $service->CreateCrossExchangeLedgerEntries($exchange);
        } else {
            $service->CreateBuyingExchangeLedgerEntries($exchange);
        }
        // $description = generateTransferDescription($exchange);
        // $old_desc = $exchange->notes;
        // $exchange->notes = $old_desc . " " . $description;
        // $exchange->save();
    }
}
