<?php

namespace App\Providers;

use Bavix\Wallet\Internal\Service\MathServiceInterface;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Vite;
use Bavix\Wallet\WalletServiceProvider;
use Bavix\Wallet\Models\Wallet as BaseWallet;
use App\Models\Wallet;
use Bavix\Wallet\Models\Transaction as BaseTransaction;
use Bavix\Wallet\Internal\Events\TransactionCreatedEventInterface;
use App\Listeners\SetTransactionCreatorListener;
use App\Models\Agent;
use App\Models\Contract;
use App\Models\Currency;
use App\Models\Exchange;
use App\Models\Invoice;
use App\Models\LedgerApproval;
use App\Models\LedgerBooking;
use App\Models\LedgerCashier;
use App\Models\LedgerSyp;
use App\Models\LedgerTransfer;
use App\Models\Rent;
use App\Models\Shortcut;
use App\Observers\AgentObserver;
use App\Observers\ApprovalObserver;
use App\Observers\BookingObserver;
use App\Observers\CashierLedgerObserver;
use App\Observers\ContractObserver;
use App\Observers\CurrencyObserver;
use App\Observers\ExchangeObserver;
use App\Observers\InvoiceObserver;
use App\Observers\LedgerSypObserver;
use App\Observers\RentObserver;
use App\Observers\TransferObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Support\Facades\Event;
use Rawilk\Settings\Facades\Settings;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
  /**
   * Register any application services.
   */

  public function register(): void
  {
    if ($this->app->environment('local') && class_exists(\Laravel\Telescope\TelescopeServiceProvider::class)) {
      $this->app->register(\Laravel\Telescope\TelescopeServiceProvider::class);
      $this->app->register(TelescopeServiceProvider::class);
    }

    $this->app->bind(BaseWallet::class, function ($app) {
      return new Wallet();
    });
  }

  /**
   * Bootstrap any application services.
   */
  public function boot(): void
  {
    $host = request()->getHost();

    if ($host === env('ADMIN_URL')) {
      config(['session.cookie' => 'admin_session']);
    }

    if ($host === env('AGENT_URL')) {
      config(['session.cookie' => 'agent_session']);
    }
    Vite::useStyleTagAttributes(function (?string $src, string $url, ?array $chunk, ?array $manifest) {
      if ($src !== null) {
        return [
          'class' => preg_match("/(resources\/assets\/vendor\/scss\/(rtl\/)?core)-?.*/i", $src) ? 'template-customizer-core-css' : (preg_match("/(resources\/assets\/vendor\/scss\/(rtl\/)?theme)-?.*/i", $src) ? 'template-customizer-theme-css' : '')
        ];
      }
      return [];
    });

    // Set default view variables for testing environment
    if ($this->app->environment('testing')) {
      View::share('companyName', 'Transfer System Test');
      View::share('companyAddress', 'Test Address');
      View::share('companyEmail', 'test@transfer.com');
      View::share('companyPhone', '+1234567890');
      View::share('logo', '');
      View::share('shortcuts', collect());
    } else {
      view()->composer('*', function ($view) {
        static $shortcuts = null;

        if ($shortcuts === null) {
          try {
            $shortcuts = Shortcut::get();
          } catch (\Exception $e) {
            $shortcuts = collect();
          }
        }

        $view->with('shortcuts', $shortcuts);
      });

      Event::listen(
        TransactionCreatedEventInterface::class,
        SetTransactionCreatorListener::class,
      );

      LedgerCashier::observe(CashierLedgerObserver::class);
      LedgerTransfer::observe(TransferObserver::class);
      LedgerBooking::observe(BookingObserver::class);
      LedgerApproval::observe(ApprovalObserver::class);
      LedgerSyp::observe(LedgerSypObserver::class);
      Currency::observe(CurrencyObserver::class);
      Agent::observe(AgentObserver::class);
      // Exchange::observe(ExchangeObserver::class);

      try {
        $companyName = Settings::get('general.company_name');
        $companyAddress = Settings::get('general.city') . ' ' . Settings::get('general.address');
        $companyEmail = Settings::get('general.email');
        $companyPhone = Settings::get('general.phone');
        // Share them with all views:
        View::share('companyName', $companyName);
        View::share('companyAddress', $companyAddress);
        View::share('companyEmail', $companyEmail);
        View::share('companyPhone', $companyPhone);
        View::share('logo', 'storage/Logo/' . Settings::get('logo', null));
      } catch (\Exception $e) {
        // Use default values if settings are not available
        View::share('companyName', 'Transfer System');
        View::share('companyAddress', 'N/A');
        View::share('companyEmail', 'noreply@transfer.com');
        View::share('companyPhone', 'N/A');
        View::share('logo', '');
      }
    }
  }
}
