<?php
// app/Services/ExchangeRates/Providers/OpenExchangeRatesProvider.php
namespace App\Services\ExchangeRates\Providers;

use App\Services\ExchangeRates\Contracts\ExchangeRateProvider;
use Illuminate\Support\Facades\Http;

class OpenExchangeRatesProvider implements ExchangeRateProvider
{
    protected $appId;

    public function __construct()
    {
        $this->appId = config('services.openexchangerates.app_id');
    }

    public function getRate(string $fromCurrency, string $toCurrency): ?float
    {
        $response = Http::get("https://openexchangerates.org/api/latest.json", [
            'app_id' => $this->appId,
            'base' => $fromCurrency,
        ]);

        if ($response->ok() && isset($response['rates'][$toCurrency])) {
            return (float) $response['rates'][$toCurrency];
        }

        return null;
    }
    public function getAllRates(): array
    {
        $response = Http::get("https://openexchangerates.org/api/latest.json", [
            'app_id' => $this->appId,
        ]);

        return $response['rates'] ?? [];
    }
}
