<?php

namespace App\Services;

use thiagoalessio\TesseractOCR\TesseractOCR;

class IDCardParser
{
    public static function parse($imagePath, $templateKey)
    {
        $templates = config('id_templates');

        if (!isset($templates[$templateKey])) {
            throw new \Exception("Unknown template: $templateKey");
        }

        $template = $templates[$templateKey];

        $text = (new TesseractOCR($imagePath))
            ->lang($template['lang'])
            ->run();

        $results = [];
        echo $text;
        foreach ($template['fields'] as $field => $pattern) {

            preg_match($pattern, $text, $matches);
            $results[$field] = $matches[1] ?? null;
        }

        return $results;
    }
}
