<?php

namespace App\Services;

use App\Services\Contracts\NotificationStrategy;

class NotificationSender
{
    protected NotificationStrategy $strategy;

    public function __construct(NotificationStrategy $strategy)
    {
        $this->strategy = $strategy;
    }

    public function setStrategy(NotificationStrategy $strategy): void
    {
        $this->strategy = $strategy;
    }

    public function send(string $to, string $message, array $meta = []): bool
    {
        return $this->strategy->send($to, $message, $meta);
    }
}
