<?php

namespace App\Services\Transfer;

use App\Models\Agent;
use Abivia\Ledger\Models\LedgerAccount;
use Illuminate\Support\Facades\Log;

class LedgerAccountSelectorService
{
    public function getAccountOptions(): array
    {
        $agentAccounts = LedgerAccount::where('category', 0)
            ->whereNotNull('extra->agent_id')
            ->get()
            ->map(function ($account) {
                $agent = Agent::find($account->extra['agent_id']);
                Log::info($agent);
                return [
                    'id' => $account->uuid,
                    'label' => 'Agent: ' . $agent?->name,
                    'type' => 'agent',
                    'agent_id' => $account->extra['agent_id'],
                ];
            });

        $systemAccounts = LedgerAccount::where('category', 0)
            ->whereNull('extra->agent_id')
            ->get()
            ->map(function ($account) {
                return [
                    'id' => $account->id,
                    'label' => 'Account: ' . $account->name,
                    'type' => 'ledger',
                    'agent_id' => null,
                ];
            });

        return $agentAccounts->concat($systemAccounts)->toArray();
    }
}
