<?php

namespace App\Services;

use App\Exceptions\CreditLimitExceededException;
use App\Models\Agent;
use App\Models\AgentCurrencyCreditLimit;
use App\Models\AgentGlobalCreditLimit;
use App\Models\Currency;
use App\Models\ExchangeRateService; // خدمة لتحويل العملات
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;

class TransferCreditLimitValidator
{
  public function validate(Agent $agent, string $currencyCode, float $amount, $transfer_type = "transfer"): void
  {

    $globalLimit = AgentGlobalCreditLimit::where('agent_id', $agent->id)->first();
    Log::info("Global credit limit for agent {$agent->id}: ", ['limit' => $globalLimit]);
    Log::info($globalLimit);
    $new_balance =   [
      'currency' => $currencyCode,
      'balance' => (float) $amount * -1,
      'account_count' => 1,
      'formatted_balance' => PriceFormat(abs(round($amount)), $currencyCode),
      'abs_balance' => abs($amount)
    ];





    $balances = $this->getBalances($agent)->push($new_balance);

    if ($globalLimit && $transfer_type == "approval" && ($globalLimit->approval_credit_limit != null)) {

      $convertedAmount = getBaseCurrencyBalance($balances); // This must be a float
      Log::info("Converted amount: " . $convertedAmount);

      if ($transfer_type == "approval"  && $convertedAmount < 0 && abs($convertedAmount) >  $globalLimit->approval_credit_limit) {
        $msg = __("Exceeded total credit limit");
        Log::info($msg);
        throw new CreditLimitExceededException($msg);
      }
    }



    if ($globalLimit && ($globalLimit->transfer_status || $globalLimit->approval_credit_limit != null)) {

      $convertedAmount = getBaseCurrencyBalance($balances); // This must be a float
      Log::info("Converted amount: " . $convertedAmount);

      if ($transfer_type == "transfer"  && abs($convertedAmount) >  $globalLimit->base_credit_limit) {
        $msg = __("Exceeded total credit limit");
        Log::info($msg);
        throw new CreditLimitExceededException($msg);
      }
    } else {

      $balance = $balances->firstWhere('currency', $currencyCode);

      $currency_balance = $balance ? $balance['balance'] : 0;
      $currencyLimit = AgentCurrencyCreditLimit::where('agent_id', $agent->id)
        ->where('currency_code', $currencyCode)
        ->first();
      $currency_credit_limit = $currencyLimit ? $currencyLimit->credit_limit : 0;

      Log::info("Currency balance: " . $currency_balance);
      if ($currencyLimit && $currency_balance < 0 && abs($currency_balance) + ($amount) > $currency_credit_limit) {
        $msg = __("Exceeded currency credit limit");
        Log::info($msg);
        throw new CreditLimitExceededException($msg);
      }
    }
  }

  public function getBalances($agent)
  {
    if (!$agent) {
      return [];
    }

    return $agent->getAgentBalances();
  }
}
