<?php

namespace App\View\Components;

use Illuminate\View\Component;

class DecimalInput extends Component
{
    public $name;
    public $model;
    public $placeholder;
    public $tabindex;
    public $required;
    public $min;
    public $max;
    public $step;

    public function __construct(
        $name,
        $model,
        $placeholder = '0.00',
        $tabindex = null,
        $required = false,
        $min = null,
        $max = null,
        $step = '0.01'
    ) {
        $this->name = $name;
        $this->model = $model;
        $this->placeholder = $placeholder;
        $this->tabindex = $tabindex;
        $this->required = $required;
        $this->min = $min;
        $this->max = $max;
        $this->step = $step;
    }

    public function render()
    {
        return view('components.decimal-input');
    }
}
