<?php

namespace Database\Factories;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Category>
 */
class CategoryFactory extends Factory
{
    protected $model = Category::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->word . ' Expenses',
            'ledger_account_code' => $this->faker->unique()->numerify('5###'),
            'parent_id' => null,
        ];
    }

    public function withParent(Category $parent)
    {
        return $this->state([
            'parent_id' => $parent->id,
        ]);
    }
}
