<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\LedgerBooking;
use App\Models\Agent;
use App\Models\Currency;
use App\Models\Client;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\LedgerBooking>
 */
class LedgerBookingFactory extends Factory
{
    protected $model = LedgerBooking::class;

    public function definition(): array
    {
        return [
            'sender_id' => Agent::factory(),
            'receiver_id' => Agent::factory(),
            'client_id' => Client::factory(),
            'amount' => $this->faker->randomFloat(2, 10, 10000),
            'currency' => 'USD',
            'delivery_amount' => $this->faker->randomFloat(2, 10, 10000),
            'delivery_currency' => 'TRY',
            'fee' => $this->faker->randomFloat(2, 0, 100),
            'recipient_name' => $this->faker->name,
            'recipient_phone' => $this->faker->phoneNumber,
            'recipient_address' => $this->faker->address,
            'date' => now()->format('Y-m-d'),
            'reference' => $this->faker->unique()->numerify('BK########'),
            'secret' => $this->faker->unique()->numerify('######'),
            'type' => 'booking',
            'status' => 'pending',
            'user_id' => 1, // Default user ID
            'notes' => $this->faker->optional()->sentence,
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }

    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'pending',
        ]);
    }

    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'completed',
        ]);
    }

    public function cancelled(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'cancelled',
        ]);
    }
}
