<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ledger_transfers', function (Blueprint $table) {

            $table->id();
            $table->foreignId('sender_id')->constrained('agents');
            $table->foreignId('receiver_id')->constrained('agents');
            $table->decimal('amount', 15, 2);
            $table->decimal("delivery_amount", 15, 2)->default(0);
            $table->decimal('send_fee', 15, 2)->default(0);
            $table->string('currency', 3)->default('USD');
            $table->enum('status', ['pending', 'paid', 'received', 'cancelled', 'completed'])->default('pending');
            $table->string('reference')->unique();
            $table->uuid('ledger_journal_uuid')->nullable();
            $table->json('customer_details')->nullable();
            $table->string('type')->default('transfer'); // Could be 'agent', 'bank', 'wallet', etc.
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->float("sender_fee")->default(0);
            $table->float("receiver_fee")->default(0);
            $table->string("delivery_currency")->default("USD");
            $table->string("secret")->nullable();
            $table->dateTime("delivered_at")->nullable();
            $table->string("notes")->nullable();
            $table->integer("client_id")->foreign()->nullable()->constrained('clients');
            $table->date("date")->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ledger_transfers');
    }
};
